   Declare   @FromDate            VARCHAR(20)  = '2014-05-01'--DATEADD(mm,-12,getdate())                                                           
     Declare   @ToDate            VARCHAR(20)  = '2015-05-01'--DATEADD(mm, 1, getdate())                                                               
                                                                          
 IF OBJECT_ID('tempdb..#TEMP_EveryWk_Sndays') IS NOT NULL                                                                          
    DROP TABLE #TEMP_EveryWk_Sndays                                                                       
                                                                          
 DECLARE @TOTALCount INT                                          
    Select  @TOTALCount= DATEDIFF(dd,@FromDate,@ToDate);           
   WITH d AS                                                                       
            (                                                                      
              SELECT top (@TOTALCount) AllDays = DATEADD(DAY, ROW_NUMBER()                                                                       
                OVER (ORDER BY object_id), REPLACE(@FromDate,'-',''))                                                                      
              FROM sys.all_objects                                             
            )                                                                      
                                                                            
         SELECT  distinct DATEADD(DAY, 1 - DATEPART(WEEKDAY, AllDays), CAST(AllDays AS DATE))WkStartSundays  ,1 as status                                                              
                                                                           
 into #TEMP_EveryWk_Sndays                                                                    
    FROM d                             
   where                          
        AllDays  <= @ToDate                                      
   AND AllDays  >= @FromDate        

 IF OBJECT_ID('tempdb..#TEMP_results') IS NOT NULL                                                                          
    DROP TABLE #TEMP_results   
 
   SELECT ProjectName,viewtype,ProjectType,resultnew,YMWK
   INTO #TEMP_results
   FROM(
   
  
    select                                                                
      A.ProjectName ProjectName                                          
   ,'1-Scd' viewtype                                                              
  , A. ProjectType ProjectType  
, case when min(A.SCHED_ST_DT)<= F.WkStartSundays AND max(A.SCHED_ED_DT) >= F.WkStartSundays                                                        
 then 1 else 0 end resultnew  -- perfectResult as i expect                                    
  , CONVERT(char(7),  F.WkStartSundays,126)+'-'+'W'+convert(varchar(2),Case when len(DATEPART( wk, WkStartSundays))='1' then '0'+                                
  cast(DATEPART( wk, WkStartSundays) as varchar(2)) else cast(DATEPART( wk, WkStartSundays) as varchar(2)) END                             
  ) as 'YMWK'                   

  from                                                             
   SCHED_Master A (NOLOCK)       
     LEFT OUTER JOIN #TEMP_EveryWk_Sndays F (NOLOCK)  ON A.status= F.status                                                            
                                          
    where                                                            
    A.status=1                                                                          
      AND A.ProjectType in (1,2,3) 
     AND A.SCHED_ST_DT  <= @ToDate                                          
   AND A.SCHED_ED_DT  >= @FromDate  
    group by                                                               
       A.ProjectName                                                         
  , A. ProjectType  
  ,A.SCHED_ED_DT                   
,F.WkStartSundays

union 
select                                                                
      A.ProjectName ProjectName                                          
   ,'2-ACT' viewtype                                                              
  , A. ProjectType ProjectType  
, case when min(A.ACT_ST_DT)<= F.WkStartSundays AND max(A.ACT_ED_DT) >= F.WkStartSundays                                                        
 then 1 else 0 end resultnew  -- perfectResult as i expect                                    
  , CONVERT(char(7),  F.WkStartSundays,126)+'-'+'W'+convert(varchar(2),Case when len(DATEPART( wk, WkStartSundays))='1' then '0'+                                
  cast(DATEPART( wk, WkStartSundays) as varchar(2)) else cast(DATEPART( wk, WkStartSundays) as varchar(2)) END                             
  ) as 'YMWK'                  

  from                                                             
   SCHED_Master A (NOLOCK)       
     LEFT OUTER JOIN #TEMP_EveryWk_Sndays F (NOLOCK)  ON A.status= F.status                                                            
                                          
    where                                                            
    A.status=1                                                                          
      AND A.ProjectType in (1,2,3) 
     AND A.ACT_ST_DT  <= @ToDate                                          
   AND A.ACT_ED_DT  >= @FromDate  
    group by                                                               
       A.ProjectName                                                         
  , A. ProjectType  
  ,A.ACT_ED_DT                   
,F.WkStartSundays

 )  q                 


DECLARE @MyColumns AS NVARCHAR(MAX),
    @SQLquery  AS NVARCHAR(MAX)
 --here first we get all the ItemName which should be display in Columns we use this in our necxt pivot query
select @MyColumns = STUFF((SELECT ',' + QUOTENAME(YMWK) 
                    FROM #TEMP_results
                    GROUP BY YMWK
                    ORDER BY YMWK
            FOR XML PATH(''), TYPE
            ).value('.', 'NVARCHAR(MAX)') 
        ,1,1,'')
 --here we use the above all Item name to disoplay its price as column and row display
set @SQLquery = N'SELECT ProjectName,viewtype,ProjectType,' + @MyColumns + N' from 
             (
                 SELECT 
       ProjectName, 
       viewtype,
       ProjectType,
       YMWK,
        resultnew as resultnew 
    FROM #TEMP_results
            ) x
            pivot 
            (
                 sum(resultnew)
                for YMWK in (' + @MyColumns + N')
            ) p  order by ProjectName, ProjectType,viewtype'

exec sp_executesql @SQLquery;
